import { useEffect, useRef } from "react";
import BtnGroup from "../Buttons/BtnGroup.js";
import styles from "./form.module.scss";

const ScheduleForm = () => {

    return (
        <form className="my-5">
            <input className="form-control form-control-lg mb-4" type="text" placeholder="제목" aria-label="title" autoFocus />
            <div className="d-flex mb-4">
                <label className="col-3 col-form-label">시작</label>
                <div className="col-5">
                    <input className="form-control" type="date" aria-label="startDate" />
                </div>
                <div className="col-4">
                    <input className="form-control" type="time" aria-label="startTime" />
                </div>
            </div>
            <div className="d-flex mb-3">
                <label className="col-3 col-form-label">종료</label>
                <div className="col-5">
                    <input className="form-control" type="date" aria-label="endDate" />
                </div>
                <div className="col-4">
                    <input className="form-control" type="time" aria-label="endTime" />
                </div>
            </div>
            <div className="d-flex justify-content-end form-check">
                <input className={`form-check-input border-dark shadow-none ${styles.checkBox}`} type="checkbox" value="" id="allDay" />
                <label className="form-check-label" htmlFor="allDay">하루 종일</label>
            </div>
            <BtnGroup />
        </form>
    )
}

export default ScheduleForm