import jwt from "jsonwebtoken";
import { User } from '../db/index.js';
import config from "../config/app.config.js";

const signup = async (req, res) => {
  console.log('server/signup req.body', req.body)
  const { userId, password, userName, userStudNum } = req.body;
  try {
    const findId = await User.findOne({ where: { userID: userId } });
    if (findId) {
      throw new Error("이미 있는 회원정보 입니다.");
    }
    await User.create({
      userID: userId,
      password: password,
      userName: userName,
      studNum: userStudNum
    });
    res.status(201).json("success")
  } catch (error) {
    console.log(error)
    return res.status(500).send(error.message || "회원가입 에러발생")
  }
}

const login = async (req, res) => {
  console.log('server/login req.body', req.body)
  const { userId, password } = req.body;
  try {
    const user = await User.scope("withPassword").findOne({ where: { userID: userId } });
    console.log('user확인', user)
    if (!user) {
      return res.status(404).send(`일치하는 정보가 없습니다.`);
    }
    const passwordMatch = await user.comparePassword(password);
    if (passwordMatch) {

      const signData = {
        id: user.userID,
        name: user.userName
    };

      const token = jwt.sign(signData, config.jwtSecret, {
        expiresIn: config.jwtExpires,
      });

      res.cookie(config.cookieName, token, {
        maxAge: config.cookieMaxAge,
        path: "/",
        httpOnly: config.env === "production",
        secure: config.env === "production",
      });

      res.status(201).json(user)
    } else { 
      res.status(401).send("비밀번호가 일치하지 않습니다.")
    }

  } catch (error) {
    console.log(error)
    return res.status(500).send("로그인 에러발생")
  }
}

export default {
  signup,
  login
}