import React from 'react';
import { Formik } from 'formik';
import * as Yup from 'yup';

const SignupForm = () => {
  return (
    <>
      <div className="py-5">
        <h1 className="text-center">회원가입</h1>
      </div>
      <Formik
        initialValues={{
          userId: '',
          password: '',
          repassword: '',
          userName: '',
          userStudNum: ''
        }}
        validationSchema={Yup.object({
          userId: Yup.string()
            .required('아이디를 입력해주세요.')
            .max(15, '15자 이내로 입력해주세요.')
            .min(5, '최소 5자 이상 입력해주세요.'),
          password: Yup.string()
            .required('비밀번호를 입력해주세요.')
            .min(8, '최소 8자 이상 입력해주세요.'),
          repassword: Yup.string()
            .required('비밀번호를 입력해주세요.')
            .min(8, '최소 8자 이상 입력해주세요.')
            .oneOf([Yup.ref("password"), null], '비밀번호가 일치하지 않습니다.'),
          userName: Yup.string()
            .required('이름을 입력해주세요.'),
          userStudNum: Yup.string()
            .required('학번을 입력해주세요.')
            .min(7, '학번을 정확히 입력해주세요.'),
        })}
        onSubmit={(values, { setSubmitting }) => {
          setTimeout(() => {
            alert(JSON.stringify(values, null, 2));
            setSubmitting(false);
          }, 400);
        }}
      >
        {formik => (
          <form onSubmit={formik.handleSubmit} className="mt-3">
            <div className="mb-3 d-flex flex-row">
              <label className="form-label" style={{ width: "100px" }}>아이디</label>
              <div className="flex-col">
                <input type="text" name="userId"
                  className="form-control border-top-0 border-end-0 border-start-0"
                  style={{ boxShadow: "none", borderRadius: "0" }}
                  {...formik.getFieldProps('userId')} />
                {formik.touched.userId && formik.errors.userId ? (
                  <div className="text-danger" style={{ fontSize: "10px" }}>{formik.errors.userId}</div>
                ) : null}
              </div>
            </div>
            <div className="mb-3 d-flex flex-row">
              <label className="form-label" style={{ width: "100px" }}>비밀번호</label>
              <div className="flex-col">
                <input type="password" name="password"
                  className="form-control border-top-0 border-end-0 border-start-0"
                  style={{ boxShadow: "none", borderRadius: "0" }}
                  {...formik.getFieldProps('password')} />
                {formik.touched.password && formik.errors.password ? (
                  <div className="text-danger" style={{ fontSize: "10px" }}>{formik.errors.password}</div>
                ) : null}
              </div>
            </div>
            <div className="mb-3 d-flex flex-row">
              <label className="form-label" style={{ width: "100px", wordBreak: "keep-all" }}>비밀번호 확인</label>
              <div className="flex-col">
                <input type="password" name="repassword"
                  className="form-control border-top-0 border-end-0 border-start-0"
                  style={{ boxShadow: "none", borderRadius: "0" }}
                  {...formik.getFieldProps('repassword')} />
                {formik.touched.repassword && formik.errors.repassword ? (
                  <div className="text-danger" style={{ fontSize: "10px" }}>{formik.errors.repassword}</div>
                ) : null}
              </div>
            </div>
            <div className="mb-3 d-flex flex-row">
              <label className="form-label" style={{ width: "100px" }}>이름</label>
              <div className="flex-col">
                <input type="text" name="userName"
                  className="form-control border-top-0 border-end-0 border-start-0"
                  style={{ boxShadow: "none", borderRadius: "0" }}
                  {...formik.getFieldProps('userName')} />
                {formik.touched.userName && formik.errors.userName ? (
                  <div className="text-danger" style={{ fontSize: "10px" }}>{formik.errors.userName}</div>
                ) : null}
              </div>
            </div>
            <div className="mb-3 d-flex flex-row">
              <label className="form-label" style={{ width: "100px" }}>학번</label>
              <div className="flex-col">
                <input type="text" name="userStudNum"
                  className="form-control border-top-0 border-end-0 border-start-0"
                  style={{ boxShadow: "none", borderRadius: "0" }}
                  {...formik.getFieldProps('userStudNum')} />
                {formik.touched.userStudNum && formik.errors.userStudNum ? (
                  <div className="text-danger" style={{ fontSize: "10px" }}>{formik.errors.userStudNum}</div>
                ) : null}
              </div>
            </div>
            <div className="d-grid gap-2 ">
              <button type="submit" className="btn btn-crimson my-5">확인</button>
            </div>
          </form>
        )}
      </Formik>
    </>
  );
}

export default SignupForm;