import { useState, useEffect } from 'react';
import { useAuth } from "../utils/context";
import { Link } from "react-router-dom";
import StudyPlanCard from "./Card/StudyPlanCard";
import subjectApi from '../apis/subject.api';

const StudyPlanList = () => {
  const { user } = useAuth();
  useEffect(() => {
    getList(user.id);
  }, [])

  async function getList(id) {
    const result = await subjectApi.allSubject(id)
  }

  return (
    <>
      <StudyPlanCard />
      <div className="d-flex justify-content-center mt-3">
        <Link className="card text-decoration-none link-dark" to="/subject/edit" style={{ width: "20rem" }}>
          <div className="card-body d-flex flex-column bg-secondary bg-opacity-25">
            <div>
              <i className="bi bi-plus-lg d-flex justify-content-center fs-3"></i>
              <p className="card-text mt-2 text-center">새로운 과목 추가하기</p>
            </div>
          </div>
        </Link>
      </div>
    </>
  )
}

export default StudyPlanList;