import { Plan } from "../db/index.js";

const addPlan = async (req, res) => {
  console.log('server/addPlan req.body', req.body)
  try {
    let end = null;
    let tf = false;
    const { info } = req.body
    const { studyplanTitle, endDate, endTime, deadline, memo, selected } = info
    console.log('제목확인', studyplanTitle)
    if (deadline === "on") {
      end = new Date(endDate + " " + endTime)
      tf = true
    } else {
      end = new Date(endDate)
    }
    const result = await Plan.create({
      subjectId: selected,
      title: studyplanTitle,
      deadline: end,
      memo: memo,
      timeChecked: tf,
      checked: false
    })
    return res.json(result)
  } catch (error) {
    console.log(error)
    return res.status(500).send(error.message || "계획저장 에러발생")
  }
}

const editPlan = async (req, res) => {
  console.log('server/editPlan req.body', req.body)
  try {

  } catch (error) {
    console.log(error)
    return res.status(500).send(error.message || "계획수정 에러발생")
  }
}

const getInfo = async (req, res) => {
  console.log('server/getInfo req.params', req.params)
  try {
    const { planId } = req.params;
    const findInfo = await Plan.findOne({ where: { id: planId } })
    console.log('findInfo확인', findInfo.dataValues)
  } catch (error) {
    console.log(error)
    return res.status(500).send(error.message || "계획 가져오기 에러발생")
  }
}

export default {
  addPlan,
  editPlan,
  getInfo
}