import { useState, useEffect } from 'react';
import { Link } from "react-router-dom";
import StudyPlanCard from "./Card/StudyPlanCard";
import subjectApi from '../apis/subject.api';
import catchErrors from "../utils/catchErrors";
import { useAuth } from "../utils/context";
import styles from "./StudyPlan/studyplan.module.scss";

const StudyPlanList = () => {
  const { user } = useAuth();
  const [renList, setRenList] = useState([])
  const [error, setError] = useState("")

  useEffect(() => {
    getList(user.id);
  }, [])

  async function getList(userId) {
    try {
      setError("")
      const result = await subjectApi.allSubject(userId)
      setRenList(result)
    } catch (error) {
      catchErrors(error, setError)
    }
  }

  return (
    <div className={`mt-4 ${styles.list}`}>
      <div className="d-flex flex-column align-items-center">
        {renList.length !== 0 ? renList.map((info, idx) => <StudyPlanCard key={idx} renList={info} />) : null}
        <Link className="card text-decoration-none link-dark" to="/subject/edit" style={{ width: "20rem" }}>
          <div className="card-body d-flex flex-column bg-secondary bg-opacity-25">
            <i className="bi bi-plus-lg d-flex justify-content-center fs-3"></i>
            <p className="card-text mt-2 text-center">새로운 과목 추가하기</p>
          </div>
        </Link>
      </div>
    </div>
  )
}

export default StudyPlanList;