import { Link } from "react-router-dom";
import styles from "./schedule.module.scss";

const ScheduleItem = ({ schedule, handleClick }) => {

    return (
        <div className="accordion-item border-bottom-0">
            <button className={`d-flex flex-column align-items-start accordion-button collapsed bg-white shadow-none px-0 ${styles.activeBtn}`} type="button" data-bs-toggle="collapse" data-bs-target={schedule.id} aria-expanded="false" aria-controls={schedule.id}>
                <h5 className={`accordion-header ${styles.title}`} id={"heading" + schedule.id}>{schedule.title}</h5>
                <p className={`text-secondary mb-0 ${styles.time}`}>sadsadsdsadsadsaf</p>
                <p className={`mb-0 ${styles.period}`}>2021.01.151 ~ 2021.09.35</p>
            </button>
            <div id={schedule.id} className="accordion-collapse collapse" aria-labelledby={"heading" + schedule.id} data-bs-parent="#scheduleList">
                <div className={`accordion-body px-0 pt-2 pb-0 mb-3 ${styles.textBox}`}>
                    {schedule.location ? <div className="d-flex align-items-start">
                        <i className="col bi bi-geo-alt fs-5"></i>
                        <div className="col-11">{schedule.location}</div>
                    </div> : null}
                    {schedule.memo}
                    <div className="d-flex justify-content-end mt-3">
                        <Link className="btn btn-light btn-sm border-dark" to={`/schedule/edit/${schedule.id}`}>수정</Link>
                        <button type="button" className="btn btn-crimson btn-sm ms-2" onClick={handleClick}>삭제</button>
                    </div>
                </div>
            </div>
        </div>
    )
}

export default ScheduleItem