import { Link } from "react-router-dom";
import styles from "../Form/form.module.scss";

const PlanLineList = ({ subjectId, planList = [] }) => {
    return (
        <>
            {planList.length !== 0 ? planList.map(plan => <div className="d-flex justify-content-between">
                <p className="card-text mb-1">- {plan.title}</p>
                <input className={`form-check-input shadow-none ${styles.checkBox}`} type="checkbox" />
            </div>) : <Link className="text-decoration-none link-dark" to={`/studyplan/edit/add/${subjectId}`}>
            <div className="d-flex">
              <i className="bi bi-plus"></i>
              <p className="card-text mb-1">새로운 계획 추가하기</p>
            </div>
          </Link>}
        </>
    )
}

export default PlanLineList