import styles from "./form.module.scss";
import { Link } from "react-router-dom";

const StudyPlanListForm = () => {
  return (
    <>
      <h2 className="text-center">학업별 계획</h2>
      <div className="d-flex justify-content-center mt-3">
        <div className="card" style={{ width: "20rem" }}>
          <div className="card-body">
            <div className="d-flex justify-content-between">
              <h5 className="card-title">운영체제</h5>
              <div>
                <i className="bi bi-pencil-square pe-2"></i>
                <i className="bi bi-trash"></i>
              </div>
            </div>
            <p className="card-subtitle mb-2 text-muted">&nbsp;김민호 - 과학기술2관 310호</p>
            <div className="d-flex justify-content-between">
              <p className="card-text mb-1">- ch02 내용정리하기</p>
              <input className={`form-check-input shadow-none ${styles.checkBox}`} type="checkbox" />
            </div>
            <div className="d-flex justify-content-between">
              <p className="card-text mb-1">- ch03 내용정리하기</p>
              <input className={`form-check-input shadow-none ${styles.checkBox}`} type="checkbox" />
            </div>
          </div>
        </div>
      </div>
      <div className="d-flex justify-content-center mt-3">
        <div className="card" style={{ width: "20rem" }}>
          <div className="card-body">
            <div className="d-flex justify-content-between">
              <h5 className="card-title">네트워크 프로그래밍 및 실습</h5>
              <div>
                <i className="bi bi-pencil-square pe-2"></i>
                <i className="bi bi-trash"></i>
              </div>
            </div>
            <p className="card-subtitle mb-2 text-muted">&nbsp;임치헌 - 과학기술2관 323호</p>
            <Link className="text-decoration-none link-dark" to="/studyplan/edit">
              <div className="d-flex">
                <i class="bi bi-plus"></i>
                <p className="card-text mb-1">새로운 계획 추가하기</p>
              </div>
            </Link>
          </div>
        </div>
      </div>
      <div className="d-flex justify-content-center mt-3">
        <Link className="text-decoration-none link-dark" to="/subject/edit">
          <div className="card" style={{ width: "20rem" }}>
            <div className="card-body d-flex flex-column bg-secondary bg-opacity-25 ">
              <div>
                <i class="bi bi-plus-lg d-flex justify-content-center fs-3"></i>
                <p className="card-text mt-2 text-center">새로운 과목 추가하기</p>
              </div>
            </div>
          </div>
        </Link>
      </div>
    </>
  )
}

export default StudyPlanListForm;