import Item from "../AdminScheduleItem.js";
import moment from 'moment';
import styles from "./modal.module.scss";

const ScheduleModal = ({ dateShow, setDateShow }) => {
    return (
        <>
            {dateShow.show ? <div className="modal-backdrop fade show"></div> : null}
            <div className={"modal " + (dateShow.show ? "d-block" : "d-none")} id="scheduleModal" data-bs-backdrop="static" data-bs-keyboard="false" tabIndex="-1" aria-labelledby="scheduleModalLabel" aria-hidden="true">
                <div className="modal-dialog modal-sm modal-dialog-centered modal-dialog-scrollable">
                    <div className="modal-content">
                        <div className={`modal-header ${styles.header}`}>
                            <h5 className="modal-title text-white mx-auto" id="scheduleModalLabel">{moment(dateShow.date).format("MM.DD")}</h5>
                            <button type="button" className={`btn-close btn-close-white ms-0 ${styles.closeBtn}`} data-bs-dismiss="modal" aria-label="Close" onClick={() => setDateShow({ ...dateShow, show: false })}></button>
                        </div>
                        <div className={`modal-body text-dark ${styles.body}`}>
                            <Item />
                            <p className="text-center mb-0">선택한 날짜에 일정이 없습니다.</p>
                        </div>
                    </div>
                </div>
            </div>
        </>
    )
}

export default ScheduleModal