import { useState } from "react";
import { Link } from "react-router-dom";
import styles from "../Form/form.module.scss";

const StudyPlanCard = () => {
  // studyPlanList에서 props로 받아서 뿌리기
  return (
    <>
      <div className="d-flex justify-content-center mt-3">
        <div className="card" style={{ width: "20rem" }}>
          <Link className="text-decoration-none link-dark" to="/studyplan/1be7e4db-796d-4d9b-bfab-fdc440d25171">
            <div className="card-body">
              <div className="d-flex justify-content-between">
                <h5 className="card-title col-10">운영체제</h5>
                <div className="col-2 d-flex justify-content-end">
                  <Link className="text-decoration-none link-dark" to="/subject/edit/ed56bebd-b9ae-4065-aae2-d39aeac5f18e"><i className="bi bi-pencil-square pe-2"></i></Link>
                  <i className="bi bi-trash"></i>
                </div>
              </div>
              <p className="card-subtitle ms-1 mb-2 text-muted">김민호 - 과학기술2관 310호</p>
              <div className="d-flex justify-content-between">
                <p className="card-text mb-1">- ch02 내용정리하기</p>
                <input className={`form-check-input shadow-none ${styles.checkBox}`} type="checkbox" />
              </div>
              <div className="d-flex justify-content-between">
                <p className="card-text mb-1">- ch03 내용정리하기</p>
                <input className={`form-check-input shadow-none ${styles.checkBox}`} type="checkbox" />
              </div>
            </div>
          </Link>
        </div>
      </div>
      {/*계획 없을 때 보여질 카드*/}
      <div className="d-flex justify-content-center mt-3">
        <div className="card" style={{ width: "20rem" }}>
          <div className="card-body">
            <div className="d-flex ">
              <h5 className="card-title col-10 text-nowrap" style={{ overflow: "hidden", textOverflow: "ellipsis" }}>네트워크 프로그래밍 및 실습</h5>
              <div className="col-2 d-flex justify-content-end">
                <Link className="text-decoration-none link-dark" to="/subject/edit"><i className="bi bi-pencil-square pe-2"></i></Link>
                <i className="bi bi-trash"></i>
              </div>
            </div>
            <p className="card-subtitle ms-1 mb-2 text-muted">임치헌 - 과학기술2관 323호</p>
            <Link className="text-decoration-none link-dark" to="/studyplan/edit">
              <div className="d-flex">
                <i className="bi bi-plus"></i>
                <p className="card-text mb-1">새로운 계획 추가하기</p>
              </div>
            </Link>
          </div>
        </div>
      </div>
    </>
  )
}

export default StudyPlanCard;