import { useState, useEffect } from "react";
import BtnGroup from "../Buttons/BtnGroup.js";
import catchErrors from "../../utils/catchErrors.js";
import styles from "./form.module.scss";

const ScheduleForm = () => {
    const [schedule, setSchedule] = useState({})
    const [error, setError] = useState("")

    useEffect(() => {
    }, [])

    async function handleSubmit(e) {
        e.preventDefault()
        try {
            setError("")
        } catch (error) {
            catchErrors(error, setError)
        }
    } 

    return (
        <form className="pt-5" onSubmit={handleSubmit}>
            <input className={`form-control form-control-lg shadow-none px-1 mb-5 ${styles.textInput}`} type="text" placeholder="제목" aria-label="title" autoFocus />
            <div className="d-flex mb-4">
                <label className="col col-form-label align-self-center py-0">시작</label>
                <div className="col-5">
                    <input className={`form-control shadow-none ${styles.dateInput}`} type="date" aria-label="startDate" />
                </div>
                <div className="col-5">
                    <input className={`form-control shadow-none ${styles.dateInput}`} type="time" aria-label="startTime" />
                </div>
            </div>
            <div className="d-flex mb-3">
                <label className="col col-form-label align-self-center py-0">종료</label>
                <div className="col-5">
                    <input className={`form-control shadow-none ${styles.dateInput}`} type="date" aria-label="endDate" />
                </div>
                <div className="col-5">
                    <input className={`form-control shadow-none ${styles.dateInput}`} type="time" aria-label="endTime" />
                </div>
            </div>
            <div className="d-flex justify-content-end form-check mb-4">
                <input className={`form-check-input shadow-none ${styles.checkBox}`} type="checkbox" value="" id="allDay" />
                <label className="form-check-label ms-2" htmlFor="allDay">하루 종일</label>
            </div>
            <div className="d-flex justify-content-between align-items-center mb-4">
                <i className="col bi bi-geo-alt fs-3"></i>
                <div className="col-10">
                    <input className={`form-control shadow-none px-1 ${styles.textInput}`} type="text" placeholder="장소" aria-label="location" />
                </div>
            </div>
            <div className="d-flex justify-content-between mb-5">
                <i className="col bi bi-journal-text fs-3"></i>
                <div className="col-10">
                    <textarea className={`form-control shadow-none ${styles.textArea}`} rows="5"></textarea>
                </div>
            </div>
            <BtnGroup />
        </form>
    )
}

export default ScheduleForm