import { BrowserRouter as Router, Route, Switch } from "react-router-dom";
import LoginPage from "./pages/LoginPage";
import SignupPage from "./pages/SignupPage";
import HomePage from "./pages/HomePage";
import SchedulePage from "./pages/SchedulePage";
import ScheduleEditPage from "./pages/ScheduleEditPage";
import AdminPage from "./pages/AdminPage";
import PrivateRoute from "./components/PrivateRoute";
import Err from "./pages/ErrorPage";

function App() {
  return (
    <Router basename={process.env.PUBLIC_URL}>
      <div className="mx-auto" style={{ width: "400px" }}>
        <Switch>
          <Route exact path="/" component={Err} />
          <Route path="/signup" component={SignupPage} />
          <Route path="/home" component={HomePage} />
          <Route path="/schedule/edit" component={ScheduleEditPage} />
          <Route path="/schedule" component={SchedulePage} />
          <PrivateRoute path="/admin" component={AdminPage} role="admin" />
        </Switch>
      </div>
    </Router>
  );
}

export default App;