import { Sequelize } from "sequelize"
import dbConfig from "../config/db.config.js"
import UserModel from "../models/user.model.js";
import TodoModel from "../models/todo.model.js";
import SubjectModel from "../models/subject.model.js";

const sequelize = new Sequelize(
    String(dbConfig.database),
    String(dbConfig.username),
    dbConfig.password,
    {
        host: dbConfig.host,
        dialect: dbConfig.dialect,
        pool: {
            max: dbConfig.pool?.max,
            min: dbConfig.pool?.min,
            acquire: dbConfig.pool?.acquire,
            idle: dbConfig.pool?.idle,
        },
    }
);

const User = UserModel(sequelize)
const Todo = TodoModel(sequelize)
const Subject = SubjectModel(sequelize)

Subject.belongsTo(User)

export {
    sequelize,
    User,
    Todo,
    Subject
}