import axios from "axios";
import baseUrl from "../utils/baseUrl.js";

const signup = async (user) => {
  const url = `${baseUrl}/api/auth/signup`;
  const { data, status } = await axios.post(url, user);
  return { data, status }
}

const login = async (user) => {
  const url = `${baseUrl}/api/auth/login`;
  const { data, status } = await axios.post(url, user);
  return { data, status }
}

const authApi = {
  signup,
  login
};

export default authApi