import { BrowserRouter as Router, Route, Switch } from "react-router-dom";
import LoginPage from "./pages/LoginPage";
import SignupPage from "./pages/SignupPage";
import HomePage from "./pages/HomePage";
import SchedulePage from "./pages/SchedulePage";
import ScheduleEditPage from "./pages/ScheduleEditPage";
import ToDoPage from "./pages/ToDoPage";
import StudyPlanListPage from "./pages/StudyPlanListPage";
import StudyPlanPage from "./pages/StudyPlanPage";
import StudyPlanEditPage from "./pages/StudyPlanEditPage";
import SubjectEditPage from "./pages/SubjectEditPage";
import AdminPage from "./pages/Admin/AdminPage";
import PrivateRoute from "./components/PrivateRoute";
import ErrorPage from "./pages/ErrorPage";

function App() {
  return (
    <Router basename={process.env.PUBLIC_URL}>
      <div id="box" className="container position-relative vh-100 mx-sm-auto">
        <Switch>
          <Route exact path="/" component={LoginPage} />
          <Route path="/login" component={LoginPage} />
          <Route path="/signup" component={SignupPage} />
          <Route path="/home" component={HomePage} />
          <Route path="/schedule/edit" component={ScheduleEditPage} />
          <Route path="/schedule/:date" component={SchedulePage} />
          <Route path="/todo" component={ToDoPage} />
          <Route path="/studyplan/edit" component={StudyPlanEditPage} />
          <Route path="/studyplan/:" component={StudyPlanPage} />
          <Route path="/studyplan" component={StudyPlanListPage} />
          <Route path="/subject/edit/:subjectId" component={SubjectEditPage} />
          <Route path="/subject/edit" component={SubjectEditPage} />
          <Route path="/admin/edit" component={ScheduleEditPage} />
          <Route path="/admin" component={AdminPage} />
          {/* <PrivateRoute path="/admin" component={AdminPage} role="admin" /> */}

          <Route component={ErrorPage} />
        </Switch>
      </div>
    </Router>
  );
}

export default App;