import { Plan, Subject } from "../db/index.js";
import * as ConvertDate from "./schedule.controller.js";

const addPlan = async (req, res) => {
  console.log('server/addPlan req.body', req.body)
  try {
    let end = null;
    let tf = false;
    const { info } = req.body
    const { studyplanTitle, endDate, endTime, deadline, memo, selected } = info
    console.log('제목확인', studyplanTitle)
    if (deadline === "on") {
      end = new Date(endDate + " " + endTime)
      tf = true
    } else {
      end = new Date(endDate)
    }
    const result = await Plan.create({
      subjectId: selected,
      title: studyplanTitle,
      deadline: end,
      memo: memo,
      timeChecked: tf,
      checked: false
    })
    return res.json(result)
  } catch (error) {
    console.log(error)
    return res.status(500).send(error.message || "계획저장 에러발생")
  }
}

const editPlan = async (req, res) => {
  const { info, id } = req.body
  console.log('editPlan info', info, '|', id)
  try {
    let result = null
    if (info.deadline === "on") {
      result = await Plan.update({
        subjectId: info.selected,
        title: info.studyplanTitle,
        deadline: new Date(info.endDate + " " + info.endTime),
        memo: info.memo,
        timeChecked: true,
        checked: false
      }, { where: { id: id } })
      res.send(200)
    } else {
      result = await Plan.update({
        subjectId: info.selected,
        title: info.studyplanTitle,
        deadline: new Date(info.endDate),
        memo: info.memo,
        timeChecked: false,
        checked: false
      }, {
        where: { id: id }
      })
    }
    if (!result) {
      throw new Error("과목정보 수정 에러발생")
    } else {
      return res.send(200)
    }
  } catch (error) {
    console.log(error)
    return res.status(500).send(error.message || "계획수정 에러발생")
  }
}

const getInfo = async (req, res) => {
  console.log('server/getInfo req.params', req.params)
  try {
    let deadlineStr = null
    let endTimeStr = null

    const { planId } = req.params;
    const findInfo = await Plan.findOne({ where: { id: planId } })
    const Info = findInfo.dataValues;

    const getSubTitle = await Subject.findAll({
      attributes: ['name'],
      where: { id: Info.subjectId }
    })

    deadlineStr = ConvertDate.dateToString(Info.deadline, "full")
    endTimeStr = ConvertDate.dateToString(Info.deadline, "time")

    if (Info.timeChecked) {
      res.json({
        subjectId: Info.subjectId,
        subjectName: getSubTitle[0].dataValues.name,
        title: Info.title,
        endDate: deadlineStr,
        endTime: endTimeStr,
        deadline: "on",
        memo: Info.memo
      })
    } else {
      res.json({
        subjectId: Info.subjectId,
        subjectName: getSubTitle[0].dataValues.name,
        title: Info.title,
        endDate: deadlineStr,
        deadline: "",
        memo: Info.memo
      })
    }
  } catch (error) {
    console.log(error)
    return res.status(500).send(error.message || "계획 가져오기 에러발생")
  }
}

export default {
  addPlan,
  editPlan,
  getInfo
}