import axios from "axios";
import baseUrl from "../utils/baseUrl";

const addPlan = async (info, id) => {
  console.log('addPlan 확인', id)
  const url = `${baseUrl}/api/plan/addplan/${id}`
  const { data } = await axios.post(url, { info, id });
  return data
}

const editPlan = async (info, id) => {
  console.log('editPlan확인', id)
  const url = `${baseUrl}/api/plan/edit/${id}`
  const { data } = await axios.put(url, { info, id });
  return data
}

const getDetail = async (id) => {
  const url = `${baseUrl}/api/plan/getDetail/${id}`
  const { data } = await axios.get(url)
  return data
}
const planApi = {
  addPlan,
  editPlan,
  getDetail
};

export default planApi