import Sequelize from "sequelize";

const { DataTypes } = Sequelize;

const PlanModel = (sequelize) => {
  const Plan = sequelize.define(
    "plan",
    {
      id: {
        type: DataTypes.UUID,
        defaultValue: DataTypes.UUIDV4,
        primaryKey: true
      },
      title: {
        type: DataTypes.STRING
      },
      deadline: {
        type: DataTypes.DATE
      },
      memo: {
        type: DataTypes.STRING
      },
      timeChecked: {
        type: DataTypes.BOOLEAN
      },
      checked: {
        type: DataTypes.BOOLEAN
      }
    },
    {
      timestamps: true,
      freezeTableName: true,
      tableName: "plans",
    }
  );
  return Plan
};

export default PlanModel;