import Sequelize from "sequelize";

const { DataTypes } = Sequelize;

const SubjectModel = (sequelize) => {
  const Subject = sequelize.define(
    "subject",
    {
      id: {
        type: DataTypes.UUID, 
        defaultValue: DataTypes.UUIDV4,
        primaryKey: true
      },
      name: {
        type: DataTypes.STRING
      },
      prof: {
        type: DataTypes.STRING
      },
      room: {
        type: DataTypes.STRING
      }
    },
    {
      timestamps: true,
      freezeTableName: true,
      tableName: "subjects",
    }
  );
  return Subject
};

export default SubjectModel;