import { useState, useEffect } from 'react';
import BtnGroup from "../Buttons/BtnGroup";
import styles from "./form.module.scss";

const StudyPlanEditForm = () => {
    const [studyplan, setStudyplan] = useState({
        studyplanTitle: "",
        endDate: "",
        deadline: "",
        memo: ""
    })
    const [disabled, setDisabled] = useState(true)

    useEffect(() => {
        let isMounted = true;
        const checkInfo = { studyplanTitle: studyplan.studyplanTitle, endDate: studyplan.endDate}
        if (studyplan.deadline !== "on") {
            checkInfo.endTime = studyplan.endTime
        } else {
            delete checkInfo.endTime
        }
        if (isMounted) {
            const isStudyPlan = Object.values(checkInfo).every((el) => Boolean(el));
            isStudyPlan ? setDisabled(false) : setDisabled(true);
        }
        return () => {
            isMounted = false;
        }
    }, [studyplan])

    function handleChange(e) {
        const { name, value } = e.target
        if (name === "deadline") {
            studyplan.deadline !== "on" ? setStudyplan({ ...studyplan, [name]: value }) : setStudyplan({ ...studyplan, [name]: "off" })
        } else {
            setStudyplan({ ...studyplan, [name]: value })
        }
    }

    return (
        <>
            <div className="pt-5">
                <select className="form-select mb-4" aria-label="Default select example">
                    <option selected>관련 과목을 선택해주세요.</option>
                    <option value="1">운영체제</option>
                    <option value="2">네트워크 프로그래밍 및 실습</option>
                    <option value="3">수학적 모델링</option>
                </select>
                <input type="text" name="studyplanTitle"
                    className="form-control border-top-0 border-end-0 border-start-0 shadow-none rounded-0 mb-5"
                    placeholder="제목" onChange={handleChange} />
                <div className="d-flex mb-3">
                    <label className="col col-form-label align-self-center py-0">마감일</label>
                    <div className={studyplan.deadline === "on" ? "col-7" : "col-5"}>
                        <input className={`form-control shadow-none ${styles.dateInput}`} type="date" name="endDate" aria-label="endDate" onChange={handleChange} />
                    </div>
                    <div className={"col-4 " + (studyplan.deadline === "on" ? "d-none" : "d-block")}>
                        <input className={`form-control shadow-none ${styles.dateInput}`} type="time" name="endTime" aria-label="endTime" onChange={handleChange} />
                    </div>
                </div>
                <div className="d-flex justify-content-end form-check mb-4">
                    <input className={`form-check-input shadow-none ${styles.checkBox} me-2`} type="checkbox" id="deadline" name="deadline" onChange={handleChange} />
                    <label className="form-check-label" htmlFor="deadline">시간 </label>
                </div>
                <div className="d-flex justify-content-between mb-5">
                    <i className="col bi bi-journal-text fs-3"></i>
                    <div className="col-10">
                        <textarea className={`form-control shadow-none ${styles.textArea}`} name="memo" rows="5" onChange={handleChange}></textarea>
                    </div>
                </div>
                <BtnGroup disabled={disabled} />
            </div>
        </>
    )
}

export default StudyPlanEditForm