import { useState, useEffect } from 'react';
import BtnGroup from "../Buttons/BtnGroup";
import styles from "./form.module.scss";

const SubjectForm = () => {
  const [subject, setSubject] = useState({
    lectureName: "",
    prof: "",
    classRoom: ""
  })
  const [disabled, setDisabled] = useState(true)

  useEffect(() => {
    let isMounted = true;
    const checkInfo = { lectureName: subject.lectureName }

    if (isMounted) {
      const isSubject = Object.values(checkInfo).every((el) => Boolean(el));
      isSubject ? setDisabled(false) : setDisabled(true);
    }
    return () => {
      isMounted = false;
    }
  }, [subject])

  function handleChange(e) {
    const { name, value } = e.target
    setSubject({ ...subject, [name]: value })

  }
  return (
    <>
      <div className="position-absolute top-50 start-50 translate-middle" style={{ width: "80%" }}>
        <div>
          <div className="mb-5 d-flex flex-row">
            <label className="form-label fs-4" style={{ width: "100px" }}>강의명</label>
            <input className={`form-control shadow-none rounded-0 ${styles.textInput}`} name="lectureName" onChange={handleChange} />
          </div>
          <div className="mb-5 pt-2 d-flex flex-row">
            <label className="form-label fs-4" style={{ width: "100px" }}>교수명</label>
            <input className={`form-control shadow-none rounded-0 ${styles.textInput}`} name="prof" onChange={handleChange} />
          </div>
          <div className="mb-5 pt-2 d-flex flex-row">
            <label className="form-label fs-4 " style={{ width: "100px", letterSpacing: "15px" }}>장소</label>
            <input className={`form-control shadow-none rounded-0 ${styles.textInput}`} name="classRoom" onChange={handleChange} />
          </div>
        </div>
        <div className="pt-2">
          <BtnGroup disabled={disabled} />
        </div>
      </div>
    </>
  )
}

export default SubjectForm;