import { useState, useEffect } from 'react';
import { useAuth } from "../utils/context";
import { Link } from "react-router-dom";
import StudyPlanCard from "./Card/StudyPlanCard";
import subjectApi from '../apis/subject.api';
import styles from "./StudyPlan/studyplan.module.scss";

const StudyPlanList = () => {
  const { user } = useAuth();
  const [renList, setRenList] = useState([]);

  useEffect(() => {
    getList(user.id);
  }, [])

  async function getList(id) {
    const result = await subjectApi.allSubject(id)
    setRenList(result)
  }
  //여기서 삭제함수 만들어서 StudyPlanCard에게 넘기기
  return (
    <div className={`mt-4 ${styles.list}`}>
      {renList.length !== 0 ? renList.map((info, idx) => <StudyPlanCard key={idx} renList={info} />) : null}
      <div className="d-flex justify-content-center mt-3">
        <Link className="card text-decoration-none link-dark" to="/subject/edit" style={{ width: "20rem" }}>
          <div className="card-body d-flex flex-column bg-secondary bg-opacity-25">
            <div>
              <i className="bi bi-plus-lg d-flex justify-content-center fs-3"></i>
              <p className="card-text mt-2 text-center">새로운 과목 추가하기</p>
            </div>
          </div>
        </Link>
      </div>
    </div>
  )
}

export default StudyPlanList;