import { useState, useEffect } from 'react';
import { Redirect, useParams } from 'react-router-dom';
import { useAuth } from '../../utils/context';
import BtnGroup from "../Buttons/BtnGroup";
import subjectApi from '../../apis/subject.api';
import catchErrors from '../../utils/catchErrors';
import styles from "./form.module.scss";

const SubjectForm = () => {
  const { user } = useAuth();
  const { subjectId } = useParams();
  const [success, setSuccess] = useState(false)
  const [error, setError] = useState("");
  const [disabled, setDisabled] = useState(true)
  const [subject, setSubject] = useState({
    lectureName: "",
    prof: "",
    classRoom: ""
  })

  useEffect(() => {
    getInfo(subjectId);
  }, [])

  useEffect(() => {
    let isMounted = true;
    const checkInfo = { lectureName: subject.lectureName }

    if (isMounted) {
      const isSubject = Object.values(checkInfo).every((el) => Boolean(el));
      isSubject ? setDisabled(false) : setDisabled(true);
    }
    return () => {
      isMounted = false;
    }
  }, [subject])

  function handleChange(e) {
    const { name, value } = e.target
    setSubject({ ...subject, [name]: value })
  }

  async function getInfo(id) {
    const result = await subjectApi.getSubInfo(id)
    setSubject({
      lectureName: result.name,
      prof: result.prof,
      classRoom: result.room
    })
  }

  async function handleSubmit(e) {
    e.preventDefault();
    try {
      setError("")
      if (subjectId) {
        //수정함수 실행
        await subjectApi.editSubject(subject, subjectId)
        alert("과목정보가 수정되었습니다.")
        setSuccess(true)
      } else {
        //등록함수 실행
        const result = await subjectApi.addsubject(subject, user.id)
        if (result) {
          alert("등록되었습니다")
          setSubject({
            lectureName: "",
            prof: "",
            classRoom: ""
          })
        } else alert("등록에 실패하였습니다.")
      }
    } catch (error) {
      catchErrors(error, setError)
      setSubject({
        lectureName: "",
        prof: "",
        classRoom: ""
      })
    }

  }

  if (success) {
    return <Redirect to="/studyplan" />
  }

  return (
    <div className="position-absolute top-50 start-50 translate-middle" style={{ width: "80%" }}>
      <div>
        <div className="mb-5 d-flex flex-row">
          <label className="form-label fs-4" style={{ width: "100px" }}>강의명</label>
          <input className={`form-control shadow-none rounded-0 ${styles.textInput}`} value={subject.lectureName} name="lectureName" onChange={handleChange} />
        </div>
        <div className="mb-5 pt-2 d-flex flex-row">
          <label className="form-label fs-4" style={{ width: "100px" }}>교수명</label>
          <input className={`form-control shadow-none rounded-0 ${styles.textInput}`} value={subject.prof} name="prof" onChange={handleChange} />
        </div>
        <div className="mb-5 pt-2 d-flex flex-row">
          <label className="form-label fs-4 " style={{ width: "100px", letterSpacing: "15px" }}>장소</label>
          <input className={`form-control shadow-none rounded-0 ${styles.textInput}`} value={subject.classRoom} name="classRoom" onChange={handleChange} />
        </div>
      </div>
      <div className="pt-2">
        <BtnGroup text={subjectId} disabled={disabled} handleSubmit={handleSubmit} />
      </div>
    </div>
  )
}

export default SubjectForm;