import { Link } from "react-router-dom";
import styles from "../Form/form.module.scss";

const StudyPlanCard = ({ renList }) => {
  console.log('props 확인', renList)
  return (
    <div className="d-flex justify-content-center mt-3">
      <Link className="card text-decoration-none link-dark" style={{ width: "20rem" }} to={`/studyplan/${renList.id}`}>
        <div className="card-body">
          <div className="d-flex">
            <h5 className="card-title col-10 text-nowrap" style={{ overflow: "hidden", textOverflow: "ellipsis" }}>{renList.name}</h5>
            <div className="col-2 d-flex justify-content-end">
              <Link className="text-decoration-none link-dark" to={`/subject/edit/${renList.id}`}><i className="bi bi-pencil-square pe-2"></i></Link>
              <i className="bi bi-trash"></i>
            </div>
          </div>
          <p className="card-subtitle ms-1 mb-2 text-muted">{renList.prof && renList.room ? renList.prof + '-' + renList.room : (renList.prof || renList.room)}</p>
          {renList.planList.length !== 0 ?
            renList.planList.map((info, idx) => <><div key={idx} className="d-flex justify-content-between">
              <p className="card-text mb-1">- {info.title}</p>
              <input className={`form-check-input shadow-none ${styles.checkBox}`} type="checkbox" />
            </div><div key={idx} className="d-flex justify-content-between">
                <p className="card-text mb-1">- {info.title}</p>
                <input className={`form-check-input shadow-none ${styles.checkBox}`} type="checkbox" />
              </div> <div key={idx} className="d-flex justify-content-between">
                <p className="card-text mb-1">- {info.title}</p>
                <input className={`form-check-input shadow-none ${styles.checkBox}`} type="checkbox" />
              </div></>)

            : <Link className="text-decoration-none link-dark" to={`/studyplan/edit/add/${renList.id}`}>
              <div className="d-flex">
                <i className="bi bi-plus"></i>
                <p className="card-text mb-1">새로운 계획 추가하기</p>
              </div>
            </Link>}
        </div>
      </Link>
    </div>
  )
}

export default StudyPlanCard;