import { useState } from "react";
import { Link } from "react-router-dom";
import catchErrors from "../../utils/catchErrors.js";
import styles from "../Schedule/schedule.module.scss";
import styles2 from "./studyplan.module.scss";

const PlanItem = () => {
  const [error, setError] = useState("")

  async function delPlan() {
    try {
      setError("")
      alert("해당 일정을 삭제했습니다.")
      window.location.reload()
    } catch (error) {
      catchErrors(error, setError)
    }
  }

  return (
    <div className="d-flex">
      <input className={`form-check-input rounded-0 shadow-none mt-1 ${styles2.checkBox}`} style={{ width: "5%" }} type="checkbox" />
      <div className="accordion-item border-0 col" style={{ width: "95%" }}>
        <button className={`d-flex flex-column align-items-start accordion-button collapsed bg-white shadow-none px-0 pt-0 ps-3 ${styles.activeBtn}`} type="button" data-bs-toggle="collapse" data-bs-target="#flush-collapseOne" aria-expanded="false" aria-controls="flush-collapseOne">
          <h5 className={`accordion-header ${styles.title}`} id="flush-headingOne">
            과제02 제출하기, 코딩과제 있음ssssssssss
          </h5>
          <p className={`text-secondary mb-0 ${styles.time}`}>~21.09.30 16:00</p>
        </button>
        <div id="flush-collapseOne" className="accordion-collapse collapse" aria-labelledby="flush-headingOne" data-bs-parent="S#addplanlist">
          <div className={`accordion-body px-0 pt-2 pb-0 mb-3 ${styles.textBox}`}>
            <div className="d-flex align-items-start fw-bold">
              <i class="bi bi-clock-history fs-5"></i>
              <div className="col-11 ms-2 align-self-center">
                21.09.30 16:00
              </div>
            </div>
            컴퓨터의 프로세스 수 체크하는 프로그램 만들기 과제<br />결과화면 캡쳐해서 exe파일이랑 함께 압축하여 제출하기
            <div className="d-flex justify-content-end mt-3">
              <Link className="btn btn-light btn-sm border-dark" to="/studyplan/edit">수정</Link>
              <button type="button" className="btn btn-crimson btn-sm ms-2" onClick={delPlan}>삭제</button>
            </div>
          </div>
        </div>
      </div>
    </div>
  )
}

export default PlanItem;