import moment from 'moment';
import FullCalendar from '@fullcalendar/react';
import dayGridPlugin from '@fullcalendar/daygrid';
import interactionPlugin from "@fullcalendar/interaction";
import bootstrapPlugin from '@fullcalendar/bootstrap';
import '@fortawesome/fontawesome-free/css/all.css';

const Weekly = () => {
    return (
        <FullCalendar
            plugins={[dayGridPlugin, interactionPlugin, bootstrapPlugin]}
            initialView="dayGridWeek"
            headerToolbar={{
                start: 'title',
                center: '',
                end: ''
            }}
            titleFormat={(date) => {
                // if (date.date.)
                console.log("date==",date)
                return date.date.year + "년 " + (date.date.month + 1) + "월";
            }}
        />
    )
}

export default Weekly