import Menu from "../components/Menu/Menu.js";
import HomeBtn from "../components/Buttons/HomeBtn.js";
import Weekly from "../components/Calendar/Weekly.js";
import TodoModal from "../components/Modal/TodoModal.js";
import TodoPostModal from "../components/Modal/TodoPostModal.js";
import Footer from "../components/Footer.js";
import TodoList from "../components/TodoList.js";

const ToDoPage = () => {
    return (
        <>
            <Menu />
            <HomeBtn />
            <h1 className="text-center">To-do</h1>
            <Weekly />
            <div className="d-flex justify-content-between mt-3">
                <div className="d-flex align-items-center">
                    <input className={`form-check-input rounded-0 shadow-none mt-0 ${styles.checkBox}`} type="checkbox" />
                    <label className={`form-check-label fs-5 ms-3 ${styles.title}`}>과제03 제출하기sadsa</label>
                </div>
                <div style={{ cursor: "pointer" }}>
                    <i class="bi bi-arrow-right pe-2 fs-5" data-bs-toggle="modal" data-bs-target="#postmodal"><TodoPostModal /></i>
                    <i className="bi bi-pencil-square pe-2 fs-5" data-bs-toggle="modal" data-bs-target="#staticBackdrop"></i>
                    <TodoModal />
                    <i className="bi bi-trash fs-5"></i>
                </div>
            </div>
            <Footer />
        </>
    )
}

export default ToDoPage