// import { Link } from "react-router-dom";
import Menu from "../components/Menu/Menu.js";
import HomeBtn from "../components/Buttons/HomeBtn.js";
import styles from "../components/Form/form.module.scss";
import TodoModal from "../components/Modal/TodoModal.js";

const ToDoPage = () => {
    return (
        <>
            <Menu />
            <HomeBtn />
            <h1 className="text-center">To-do</h1>
            <div>
                캘린더 자리
            </div>
            <div className="d-flex justify-content-between mt-3">
                <div className="d-flex flex-row">
                    <input className={`form-check-input rounded-0  shadow-none mt-1 ${styles.checkBox}`} type="checkbox" />
                    <p className={`form-check-label fs-5 ms-3 ${styles.title}`}>과제03 제출하기</p>
                </div>
                <div>
                    <i class="bi bi-arrow-right pe-2 fs-5"></i>
                    <i className="bi bi-pencil-square pe-2 fs-5" data-bs-toggle="modal" data-bs-target="#staticBackdrop"><TodoModal /></i>
                    <i className="bi bi-trash fs-5"></i>
                </div>
            </div>
            <button type="button" className={`btn position-absolute bottom-0 start-0 justify-content-end d-flex justify-content-end w-100 bg-white ${styles.editBtn}`} style={{ boxShadow: "none" }}
                data-bs-toggle="modal" data-bs-target="#staticBackdrop">
                <i className={`bi bi-plus-circle ${styles.icon}`}></i>
                <TodoModal />
            </button>

        </>
    )
}

export default ToDoPage