import { useState, useEffect } from 'react';
import BtnGroup from "../Buttons/BtnGroup";
import styles from "./form.module.scss";

const SubjectForm = () => {
  const [subject, setSubject] = useState({
    lectureName: "",
    prof: "",
    classRoom: ""
  })
  const [disabled, setDisabled] = useState(true)

  useEffect(() => {
    let isMounted = true;
    const checkInfo = { lectureName: subject.lectureName, prof: subject.prof, classRoom: subject.classRoom }

    if (isMounted) {
      const isSubject = Object.values(checkInfo).every((el) => Boolean(el));
      isSubject ? setDisabled(false) : setDisabled(true);
    }
    return () => {
      isMounted = false;
    }
  }, [subject])

  function handleChange(e) {
    const { name, value } = e.target
    setSubject({ ...subject, [name]: value })

  }
  return (
    <>
      <div className="position-absolute top-50 start-50 translate-middle" style={{ width: "80%" }}>
        <div>
          <div className="mb-5 d-flex flex-row">
            <label className="form-label fs-4" style={{ width: "100px" }}>강의명</label>
            <input className="form-control border-top-0 border-end-0 border-start-0" style={{ boxShadow: "none", borderRadius: "0" }} name="lectureName" onChange={handleChange} />
          </div>
          <div className="mb-5 pt-2 d-flex flex-row">
            <label className="form-label fs-4" style={{ width: "100px" }}>교수명</label>
            <input className="form-control border-top-0 border-end-0 border-start-0" style={{ boxShadow: "none", borderRadius: "0" }} name="prof" onChange={handleChange} />
          </div>
          <div className="mb-5 pt-2 d-flex flex-row">
            <label className="form-label fs-4 " style={{ width: "100px" }}>장&nbsp;&nbsp;소</label>
            <input className="form-control border-top-0 border-end-0 border-start-0" style={{ boxShadow: "none", borderRadius: "0" }} name="classRoom" onChange={handleChange} />
          </div>
        </div>
        <div className="pt-2">
          <BtnGroup disabled={disabled} />
        </div>
      </div>
    </>
  )
}

export default SubjectForm;