import React from "react";
import { Outlet } from "react-router-dom";
import { AuthProvider } from "./auth/auth.context";
import { Footer, Header } from "./commons";
import { DndProvider } from "react-dnd/dist/core";
import { HTML5Backend } from "react-dnd-html5-backend";

const App = () => (
  <AuthProvider>
    <Header />
    <div style={{ minHeight: "80vh" }}>
      <DndProvider backend={HTML5Backend}>
        <Outlet />
      </DndProvider>
    </div>
    <Footer />
  </AuthProvider>
);

export default App;
