import mongoose from "mongoose";

const { String } = mongoose.Schema.Types

const UserSchema = new mongoose.Schema({
    name: {
        type: String,
        required: true, // 꼭 필요한 값
    },
    id: {
        type: String,
        required: true,
        unique: true,
    },
    password: {
        type: String,
        required: true,
        select: true,
    },
    number:{
        type:String,
        required:true,
        select:true,
        unique:true
    },
    tel:{
        type:String,
        required:true,
        unique:true
    },
    role: {
        type: String,
        required: true,
        default: 'user',
        enum: ['user', 'admin', 'root']
    }
}, {
    timestamps: true
})

export default mongoose.models.User || mongoose.model('User', UserSchema)