import React, { useState, useEffect } from 'react';
import { Link } from 'react-router-dom';
import ohuh from '../ohuh-sm.PNG';
import Place from '../Pages/Place.js';
import { Container, Form, Row, Col, Card, Image, InputGroup, FormControl, Button, Nav } from 'react-bootstrap';
import Paginations from '../Components/Paginations';
import axios from 'axios';
import queryString from 'query-string'
import * as Icon from 'react-bootstrap-icons';
import { isAuthenticated } from '../utils/auth';
import catchErrors from '../utils/catchErrors'

function Search(props) {

    const [state, setState] = useState(false);
    const [index, setIndex] = useState(1);
    const [search, setSearch] = useState(queryString.parse(props.location.search).keyword);
    const [bookmark, setBookmark] = useState([false, false, false, false])
    const user = isAuthenticated()
    const [association, setAssociation] = useState([{ name: " ", address: " ", img: " " }])
    const [pagePlace, setPagePlace] = useState([{ name: " ", address: " ", img: " " }, { name: " ", address: " ", img: " " }])
    const [endPage, setEndPage] = useState(1)
    const [error, setError] = useState('')

    async function getBookmark() {
        try {
            const response = await axios.get(`/api/users/bookmark?ID=${user}`)
            // setBookmark(response.data.bookmark)
        } catch (error) {
            catchErrors(error, setError(error))
        }
    }

    const getAssociation = () => {
        axios.get(`/api/search/association?keyword=${search}`)
            .then(res => {
                console.log("Associations = ", res.data)
                setAssociation(res.data)
            })
            .catch(err => {
                console.log("search.associations 에러 발생", err)
            })
    }



    useEffect(() => {
        getAssociation()
    }, []);

    useEffect(() => {
        if (association.length < 3) {
            setPagePlace(paginate(association, index, association.length))
        }
        else {
            setPagePlace(paginate(association, index, 4))
        }
        setEndPage(Math.floor((association.length / 4)))

    }, [association, index])

    useEffect(() => {
        getAssociation()
        if (state) {
            // window.location.reload()
            // return <Redirect to={{
            //         pathname: `/search?keyword=${search}`,
            //         state: { id: search },
            //     }} />;
            props.history.push('/search?keyword=' + search)
            setState(false)
            // console.log("search야", search)
        } window.addEventListener("scroll", infiniteScroll);
        return () => { window.removeEventListener("scroll", infiniteScroll); }
    }, [state]);

    const infiniteScroll = () => {
        const { documentElement, body } = document;
        const scrollHeight = Math.max(documentElement.scrollHeight, body.scrollHeight);
        const scrollTop = Math.max(documentElement.scrollTop, body.scrollTop);
        const clientHeight = documentElement.clientHeight;
        if (scrollTop + clientHeight >= scrollHeight) {
            // getReview();
            console.log("더불러")
        }
        console.log(scrollHeight, scrollTop, clientHeight)
    }

    const handlePage = (num) => {
        setIndex(num);
        console.log("pagenation num", num)
        console.log(index)
    }


    const handleChange = (e) => {
        setSearch(e.target.value);
    }

    const handleSubmit = (e) => {
        e.preventDefault()
        setState(true)
        setIndex(1)
    }

    function paginate(items, pageNumber, itemNumber) {
        const page = [];
        const startIndex = (pageNumber - 1) * itemNumber
        for (var i = 0; i < itemNumber; i++) {

            page.push(items[(startIndex + i)])
        }
        console.log("뿌릴 data22222222222222222", page)
        return page
    }

    async function handlebookmark(index) {
        if (!bookmark[index]) {
            console.log(pagePlace[index])
            try {
                const response = await axios.put(`/api/users/bookmark?ID=${user}&place=${pagePlace[index]._id}`)
                alert(response.data, '북마크가 저장되었습니다.')
                const showArr = bookmark
                showArr[index] = true
                setBookmark(showArr)
                console.log("bookmark=", bookmark)
            } catch (error) {
                catchErrors(error, setError)
            }
        } else {
            try {
                const response = await axios.delete(`/api/users/bookmark?ID=${user}&place=${pagePlace[index]._id}`)
                alert(response.data, '저장된 북마크가 삭제되었습니다.')
                const showArr = bookmark
                showArr[index] = false
                setBookmark(showArr)
                console.log("bookmark=", bookmark)
            } catch (error) {
                catchErrors(error, setError)
            }
        }
    }


    let time = new Date()

    return (
        <Container >
            <Link to="/" className="d-flex justify-content-center" ><Image  src={ohuh} /></Link>
            <Row className="mb-2" className="d-flex justify-content-center">
                <Form style={{ width: "90vw" }} onSubmit={handleSubmit}>
                    <InputGroup size="lg">
                        <FormControl
                            placeholder="검색어를 입력하세요."
                            value={search}
                            aria-label="Large"
                            aria-describedby="inputGroup-sizing-sm"
                            onChange={handleChange}
                        />
                        <InputGroup.Append>
                            <Button type="submit" variant="outline-secondary" >검색</Button>
                        </InputGroup.Append>
                    </InputGroup>
                </Form>
            </Row>
            {time.toLocaleString()}
            <Row className="d-flex flex-wrap">

                {console.log("#####################33", pagePlace)}
                {pagePlace.map((place, index) => {
                    return (
                        <Col key={index} md={6} >
                            <Card align="center" border="info" style={{ margin: "2%" }}>
                                <Row className="d-flex justify-content-center">
                                    <Card.Header style={{ margin: "0", marginLeft:"3%",marginRight:"3%",fontSize: '200%', fontWeight: 'bold', width :"100vw"}} >{place.name}
                                        {user ?
                                            <Button
                                                variant={bookmark[index] ? "primary" : "light"}
                                                onClick={() => handlebookmark(index, place)}>
                                                <Icon.BookmarkStarFill size={35} />
                                                {console.log("bookmark", bookmark)}
                                                {console.log("bookmark[index]", bookmark[index])}</Button> : null}
                                    </Card.Header>
                                </Row>
                                <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={place.img} />
                                <Card.Body>
                                    <Card.Text style={{ overflow: 'auto', fontSize: '25px', width: '100%', height: "80px" }} >
                                        {place.address} </Card.Text>
                                    <Link to={`/place?id=${index}&place=${place.name}`} >
                                        <Button variant="info"> {place.name} 자세히 살펴보기</Button>
                                    </Link>
                                </Card.Body>
                            </Card>
                        </Col>
                    )
                })}
            </Row>
            <Row className="mt-2 d-flex justify-content-center">
                <Paginations index={index} endPage={endPage} handlePage={handlePage}></Paginations>
            </Row>
        </Container >
    );
}

export default Search;
