import express from 'express'
import connectDb from "./utils/connectDb.js"
import userRouter from "./routes/user.routes.js"
import authRouter from "./routes/auth.routes.js"

connectDb()

const app = express()

app.use('/images', express.static('uploads/'))

app.use(express.json())

app.use(userRouter)
app.use(authRouter)

app.get('/', (req,res) => {
    res.send('Hello world, 안녕하세요.')
})

app.listen(3001, () => {
    console.log('Listening on port 3001')
})