import React from 'react';
import ReactDOM from 'react-dom';
import './index.css';
import 'bootstrap/dist/css/bootstrap.min.css';
import App from './App';
import Search from './Search';
import reportWebVitals from './reportWebVitals';
import Signup from './Components/Signup'
import Login from './Components/Login'
import {
  BrowserRouter as Router,
  Switch,
  Route,
  Redirect,
} from "react-router-dom";
import axios from 'axios';

axios.defaults.validateStatus = function (status){
  return status < 500;
}

ReactDOM.render(
  <React.StrictMode>
    <Router>
      <Switch>
        <Route exact path="/" component={App} />
        <Route path="/search" component={Search} />
        <Redirect path="/search/:id" to="/search" />
        <Route path='/signup' component={Signup}/>
        <Route path='/login' component={Login} />
      </Switch>
    </Router>
  </React.StrictMode>,
  document.getElementById('root')
);

// If you want to start measuring performance in your app, pass a function
// to log results (for example: reportWebVitals(console.log))
// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals
reportWebVitals();
