import React, { useEffect, useState } from 'react';
import { Link, Redirect } from 'react-router-dom';
import ohuh from './ohuh.PNG';
import { Col, FormControl, Container, Row, Form, Image, InputGroup, Button, Navbar, Nav } from 'react-bootstrap';
import { handleLogout, isAuthenticated } from './utils/auth'


function App() {
  const [state, setState] = useState(false);
  const [search, setSearch] = useState("");
  const user = isAuthenticated()

  if (state !== false) {
    return <Redirect to={{
      pathname: `/search/${search}`,
      state: { id: search },
    }} />;
  }

  const handleChange = (e) => {
    setSearch(e.target.value);
  }

  const handleSubmit = () => {
    setState(true);
  }



  return (
    <Container className="vh-100">
      <Row className="d-flex justify-content-md-center">
        {/* <Row as={Image} src={ohuh} col-sm-5 col-lg-6 offset-lg-0> */}
        <Col md={6} className="mt-5">
          <Image src={ohuh} fluid />
        </Col>
        <Col md={9} className='mr-6'>
          <Navbar bg="#fff" variant="light">
            <Nav className="mr-auto">
              {user ? <Nav.Link onClick={() => handleLogout()}>로그아웃</Nav.Link>
                : (
                  <>
                    <Nav.Link href="/signup">회원가입</Nav.Link>
                    <Nav.Link href="/login">로그인</Nav.Link>
                  </>
                )}
            </Nav>
          </Navbar>
        </Col>
        {/* </Row> */}
        <Col lg={{ span: 10, offset: 1 }} > {/*xs={{ span: 12, offset: 3 }} */}
          <InputGroup size="lg" lg={6} xs={4} fluid>
            <FormControl
              className="d-flex justify-content-lg-center"
              placeholder="검색어를 입력하세요."
              aria-label="Large"
              aria-describedby="inputGroup-sizing-sm"
              onChange={handleChange}
            />
            <InputGroup.Append>
              <Button variant="outline-secondary" onClick={handleSubmit}>검색</Button>
            </InputGroup.Append>
          </InputGroup>
          {/* <form onSubmit={handleSubmit}>
          <input className="" name="search" type="text" placeholder="검색어를 입력하세요." onChange={handleChange}></input>
          <Link to="/search"><button type="submit">검색</button></Link>
        </form> */}
        </Col>
      </Row>
    </Container>
  );
}

export default App;
