import express from 'express'
import connectDb from './utils/connectDb.js'
import placeRouter from './routes/place.routes.js'
import reviewRouter from './routes/review.routes.js'
import userRouter from "./routes/user.routes.js"
import authRouter from "./routes/auth.routes.js"
import appRouter from './routes/app.router.js'

connectDb()

const app = express()

app.use(express.json())

app.use(placeRouter)
app.use(reviewRouter)
app.use(appRouter)

app.use(userRouter)
app.use(authRouter)

app.get('/', (req, res) => {
    console.log("/ req.body", req.body)
    res.json({ message: "http://localhost3001/ 에 연결됨" })
})

app.listen(3001, () => {
    console.log('Listening on port 3001')
})