import React, { useState, useEffect } from 'react'
import { Alert, Col, Container, Form, Row, Button, Spinner } from "react-bootstrap"
import axios from "axios"
import catchErrors from '../utils/catchErrors'
import { Redirect } from 'react-router-dom'
import { handleLogin } from '../utils/auth'


const INIT_USER = {
    email: '',
    password: ''
}

function Login() {
    const [user, setUser] = useState(INIT_USER)
    const [disabled, setDisabled] = useState(true)
    const [error, setError] = useState('')
    const [success, setSuccess] = useState(false)
    const [loading, setLoading] = useState(false)

    useEffect(() => {
        const isUser = Object.values(user).every(el => Boolean(el))
        isUser ? setDisabled(false) : setDisabled(true)
    }, [user])

    function handleChange(event) {
        const {name, value} = event.target
        setUser({...user, [name]: value})
    }

    async function handleSubmit(event) {
        event.preventDefault()
        try {
            setLoading(true)
            setError('')
            const response = await axios.post('/api/auth/login', user)
            console.log(response.data)
            handleLogin(response.data.userId)
            setSuccess(true)
        } catch (error) {
            catchErrors(error, setError)
        } finally {
            setLoading(false)
        }
    }

    if (success) {
        console.log('success', success)
        return <Redirect to= '/'/>
    }

    return (
        <Container>
            <Row className= 'vh-100 flex-column align-items-center justify-content-center'>
            <h2>로그인</h2>
                <Col md={6}>
            {error && <Alert variant='danger'>
                {error}
            </Alert>}
                <Form onSubmit={handleSubmit}>
                    <Form.Group>
                        <Form.Label>이메일</Form.Label>
                        <Form.Control name='email' type='email'value={user.email} onChange={handleChange}/>
                    </Form.Group>
                    <Form.Group>
                        <Form.Label>비밀번호</Form.Label>
                        <Form.Control name='password' type='password' value={user.password} onChange={handleChange}/>
                    </Form.Group>
                    <Button disabled={disabled || setLoading} type='submit' 
                    block>
                        {loading && <Spinner as= 'span' animation= 'border' size='sm' 
                        role= 'status' aria-hidden=  'true' />}{' '}확인</Button>
                </Form>
                </Col>
            </Row>
        </Container>
    )
}

export default Login
