import mongoose from 'mongoose'
import config from '../config.js'

const connection = {}

async function connectDb() {
    if (connection.isConnected) {
        return
    }
//디비연결
    const db = await mongoose.connect(config.mongoDbUri, {
        useNewUrlParser: true,
        useUnifiedTopology: true,
        useFindAndModify: false,
        useCreateIndex: true
    })

    connection.isConnected = db.connections[0].readyState
}

export default connectDb