import React from 'react'
import { Route, Redirect } from 'react-router-dom'
import { isAuthenticated } from "../utils/auth";
//로그인 했을때 경로 실행하게 한다
function PrivateRoute({path, children}) {
    if (isAuthenticated()) {
        return (
            <Route path={path}>
                {children}
            </Route>
        )
    } else {
        return (
            <Redirect to='/login' />
        )
    }
}

export default PrivateRoute
