import React, { useEffect, useState } from 'react';
import { Link, Redirect } from 'react-router-dom';
import ohuh from './ohuh.PNG';
import { Container, Row, Form, Image, InputGroup, Button } from 'react-bootstrap';



function App() {
  const [state, setState] = useState(false);
  const [search, setSearch] = useState("");

  if (state !== false) {
    return <Redirect to={{
      pathname: `/search/${search}`,
      state: { id: search },
    }} />;
  }

  const handleChange = (e) => {
    setSearch(e.target.value);
  }

  const handleSubmit = () => {
    setState(true);
  }

  

  return (
    <Container className="vh-100">
      <Row className="d-flex justify-content-md-center">
        <Image src={ohuh} />
      </Row>
      <Row className="d-flex justify-content-md-center">
        <Form className="vw-100" onSubmit={handleSubmit}>
          <InputGroup>
            <Form.Control
              size="lg"
              placeholder="검색어를 입력하세요."
              aria-label="Large"
              aria-describedby="inputGroup-sizing-sm"
              onChange={handleChange}
            />
            <InputGroup.Append>
              <Button type='submit' variant="outline-secondary">검색</Button>
            </InputGroup.Append>
          </InputGroup>
        </Form>
      </Row>
    </Container>
  );
}

export default App;
