import Places from '../models/Place.js'
import cheerio from 'cheerio'
import fs from 'fs'
import axios from 'axios';

const searchPlace = async (req, res) => {

    const url = "https://search.naver.com/search.naver?sm=tab_hty.top&where=nexearch&query=" + encodeURI(req.params.search)
    const editUrl = /(http(s)?:\/\/)([a-z0-9\w]+\.*)+[a-z0-9]{2,4}/gi
    axios.get(url)
        .then( async (response) => {
            const html = response.data
            let $1 = cheerio.load(html);

            let places = {}
            $1('.ct_box_area').each(function (i) {
                // console.log($1('.biz_name').text())
                // console.log($1('.category').text())
                // console.log($1('.addr').text())
                // console.log($1('.t?ime highlight').text())

                
                places[i] = { name: $1('.biz_name').text(), category: $1('.category').text(), address: $1('.addr').text() }
            })
            // 값이 비어있거나 에러가 생겼을 때를 대비해 try catch를 해야함
            const newPlaces = await new Places(places[0]
            ).save()
            res.send(places)
        })
}

const searchImg = async (req, res) => {
    const imgUrl = "https://www.google.com/search?q=" + encodeURI(req.params.search) + "+site:tistory.com/&sxsrf=ALeKk023Dv08KQDodRmpB5222lQuzw2Vaw:1610612821100&source=lnms&tbm=isch"

    axios.get(imgUrl)
        .then(async (response) => {
            const html = response.data
            let name = req.params.search
            let $1 = cheerio.load(html);

            let images = $1('.RAyV4b').find('img').attr('src')

            // let images = []

            // $1('.RAyV4b').each(function (i) {
            //     images[i] = { imgUrl: $(this).find('img').atrr('src') }
            // })
            // console.log('%%%%%%%%%%%%%%%%%%%%%%%%%%%', images)
            res.send(images)
            const newPlaces = await new Places(name,images
                ).save()
        })

}


export default { searchImg, searchPlace }
