import express from "express"
import userCtrl from '../controllers/user.controller.js'

const router = express.Router()

router.route('/api/users/signup')
        .post(userCtrl.signup)

router.route('/api/users/bookmark')
        .get(userCtrl.getBookmark)
        .put(userCtrl.setBookmark)
        .delete(userCtrl.deleteBookmark)

router.param('userId', userCtrl.userById)

export default router