import React from 'react';
import ReactDOM from 'react-dom';
import './index.css';
import 'bootstrap/dist/css/bootstrap.min.css';
import App from './Pages/App'
import Search from './Pages/Search';
import reportWebVitals from './reportWebVitals';
import Signup from './Pages/Signup'
import Login from './Pages/Login'
import PrivateRoute from "./Components/PrivateRoute";
import Bookmark from "./Pages/Bookmark"
import {
  BrowserRouter as Router,
  Switch,
  Route,
  Redirect,
} from "react-router-dom";
import Place from './Pages/Place';

ReactDOM.render(
  <React.StrictMode>
    <Router>
      <Switch>
        <Route exact path="/" component={App} />
        <Route path="/search" component={Search} />
        <Route path="/place" component={Place} />
        <Route path='/signup' component={Signup} />
        <Route path='/login' component={Login} />
        <PrivateRoute path='/bookmark'><Bookmark /></PrivateRoute>
        <Redirect path="/search" to="/search" />
      </Switch>
    </Router>
  </React.StrictMode>,
  document.getElementById('root')
);

// If you want to start measuring performance in your app, pass a function
// to log results (for example: reportWebVitals(console.log))
// or send to an analytics endpoint. Learn more: https://bit.ly/CRA-vitals
reportWebVitals();
