import React, { useState, useEffect } from 'react'
import { Alert, Col, Container, Form, Row, Button, Spinner, Image, Nav, Navbar } from "react-bootstrap"
import axios from "axios"
import catchErrors from '../utils/catchErrors'
import { Redirect } from 'react-router-dom'
import { handleLogin } from '../utils/auth'
import { Link } from 'react-router-dom';
import ohuh from '../ohuh-sm.PNG';

const INIT_USER = {
    email: '',
    password: ''
}  //초기 유저에 이메일 비밀번호 설정

function Login() {
    //const [<상태 값 저장 변수>, <상태 값 갱신 함수>] = useState(<상태 초기 값>);
    const [user, setUser] = useState(INIT_USER)
    const [disabled, setDisabled] = useState(true)
    const [error, setError] = useState('')
    const [success, setSuccess] = useState(false)
    const [loading, setLoading] = useState(false)

    useEffect(() => { //참거짓 판단 값들의 원소들이 element로 들어간다 
        const isUser = Object.values(user).every(el => Boolean(el))
        isUser ? setDisabled(false) : setDisabled(true) 
    }, [user])

    function handleChange(event) {
        const {name, value} = event.target //{}안에 값을 이벤트.타겟에 지정?한다
        setUser({...user, [name]: value}) 
    }

    async function handleSubmit(event) {
        event.preventDefault() //리셋을 막는다
        try {
            setLoading(true)
            setError('') //값을 배열로 설정
            const response = await axios.post('/api/auth/login', user)
            console.log(response.data)
            handleLogin(response.data.userId)//로그인했을때 userid data를 넣는다
            setSuccess(true)
        } catch (error) {
            catchErrors(error, setError)
        } finally {
            setLoading(false)
        }
    }

    if (success) {
        alert("로그인되었습니다.")
        return <Redirect to= '/'/> //성공하면 홈화면으로 간다
    }

    return (
        <Container>
            <Navbar bg="#fff" variant="light">
                <Navbar.Brand href="/"><Image src={ohuh}/></Navbar.Brand>
            </Navbar>
            <Row className= 'mt-3 flex-column align-items-center justify-content-center'>
            <h2>로그인</h2>
                <Col md={6}>
            {error && <Alert variant='danger'>
                {error}
            </Alert>}
                <Form onSubmit={handleSubmit}>
                    <Form.Group>
                        <Form.Label>이메일</Form.Label>
                        <Form.Control name='email' type='email'value={user.email} onChange={handleChange}/>
                    </Form.Group>
                    <Form.Group>
                        <Form.Label>비밀번호</Form.Label>
                        <Form.Control name='password' type='password' value={user.password} onChange={handleChange}/>
                    </Form.Group>
                    <Button variant="info" disabled={disabled || setLoading} type='submit' 
                    block>
                        {loading && <Spinner as= 'span' animation= 'border' size='sm' 
                        role= 'status' aria-hidden=  'true' />}{' '}확인</Button>
                    <Link to='/signup'>
                    회원이 아니신가요?
                    </Link>
                </Form>
                </Col>
            </Row>
        </Container>
    )
}

export default Login
