import React, { useState, useEffect } from 'react'
import { Col, Card, Container, Row, Button, Nav, Navbar, Image } from "react-bootstrap"
import axios from "axios"
import ohuh from '../ohuh-sm.PNG';
import catchErrors from '../utils/catchErrors.js'
import { isAuthenticated } from '../utils/auth'
import * as Icon from 'react-bootstrap-icons';
import { Link } from 'react-router-dom'




function Bookmark() {
    const [error, setError] = useState('')
    const [bookmark, setBookmark] = useState([])
    const [pagePlace, setPagePlace] = useState([])

    const user = isAuthenticated()

    async function getBookmark() {
        try {
            console.log("bookmarkArr 까지는 온다.")
            const bookmarkArr = [];
            const response = await axios.get(`/api/users/bookmark?ID=${user}`)
            setPagePlace(response.data.bookmark)
            for (let a = 0; a < pagePlace.length; a++) {
                bookmarkArr.push(true)
            }
            setBookmark(bookmarkArr)
            console.log("bookmarkArr=",bookmarkArr)
        } catch (err) {
            catchErrors(err, setError(err))
            console.log("북마크에러", error)
        }
    }


    async function handleBookmark(index) {
        if (!bookmark[index]) {
            console.log(pagePlace[index])
            try {
                const response = await axios.put(`/api/users/bookmark?ID=${user}&place=${pagePlace[index]._id}`)
                alert(response.data, '북마크가 저장되었습니다.')
                const showArr = bookmark
                showArr[index] = true
                setBookmark(showArr)
                console.log("bookmark=", bookmark)
            } catch (error) {
                catchErrors(error, setError)
            }
        } else {
            try {
                const response = await axios.delete(`/api/users/bookmark?ID=${user}&place=${pagePlace[index]._id}`)
                alert(response.data, '저장된 북마크가 삭제되었습니다.')
                const showArr = bookmark
                showArr[index] = false
                setBookmark(showArr)
                console.log("bookmark=", bookmark)
            } catch (error) {
                catchErrors(error, setError)
            }
        }
    }
    useEffect(() => {
        getBookmark()
    }, [bookmark])


    return (
        <Container>
            {/* <Link to="/" >
                <Image style={{ margin: "1%" }} src={ohuh} />
            </Link>
            <Navbar bg="info" variant="dark">
                <Navbar.Brand href="/">북마크</Navbar.Brand>
                <Nav className="mr-auto">
                    <Nav.Link href="/">Home</Nav.Link>
                </Nav>
            </Navbar> */}
            <Link to="/" className="d-flex justify-content-center"><Image style={{ margin: "1%" }} src={ohuh} /></Link>
            <div class="d-flex align-items-center p-3 text-white bg-info rounded shadow-sm">
                <div >
                    <h1 class="h6 mb-0 text-white">북마크</h1>
                </div>
            </div>
            <Row className="d-flex flex-wrap">
                {console.log("#####################33", pagePlace)}
                {pagePlace.map((place, index) => {
                    return (
                        <Col key={index} md={6} >
                            <Card align="center" border="info" style={{ margin: "3%" }}>

                                <Card.Header className="d-flex justify-content-center" style={{ margin: "0", fontSize: '200%', fontWeight: 'bold' }} >{place.name}
                                    {user ?
                                        <Button
                                            className="float-right"
                                            variant={bookmark[index] ? "info" : "light"}
                                            onClick={() => handleBookmark(index, place)}>
                                            <Icon.BookmarkStarFill size={35} />
                                            {console.log("bookmark", bookmark)}
                                            {console.log("bookmark[index]", bookmark[index])}</Button> : null}
                                </Card.Header>
                                <Card.Img variant="top" style={{ padding: "5%", width: "100%", height: "340px" }} src={place.img} />
                                <Card.Body >
                                    <Card.Text style={{ overflow: 'auto', fontSize: '25px', width: '100%', height: "80px" }} >
                                        {place.address} </Card.Text>
                                    <Link to={`/place?&place=${place.name}`} >
                                        <Button variant="info"> {place.name} 자세히 살펴보기</Button>
                                    </Link>
                                </Card.Body>
                            </Card>
                        </Col>
                    )
                })}


            </Row>
        </Container >
    )
}

export default Bookmark


    // async function handleSubmit(e){
        //     setState(true);  //버튼이 눌려서 handlesubmit이될때 setState값이 true로 바뀐다
    //     try { //respons 서버에 post로 요청하여 데이터를 받아온다
    //         const response = await axios.post('/api/users/bookmark', page)
    //         setSuccess(true)
    //     } catch (error) {
    //         console.log(error)
    //         catchErrors(error, setError)
    //     }
    // }

    // useEffect(() => {
    //     getBookmark(user)
    // }, [user])