import User from "../models/User.js"
import isLength from 'validator/lib/isLength.js'
import isEmail from "validator/lib/isEmail.js"
import bcrypt from "bcryptjs";

const signup = async (req, res) => {
    const { name, email, password } = req.body //구조분해해서 하나씩
    console.log(name, email, password)
    try {
        if (!isLength(name, { min: 3, max: 10 })) {
            return res.status(422).send('이름은 3-10자 사이입니다')
        } else if (!isLength(password, { min: 6 })) {
            return res.status(422).send('비밀번호는 6자 이상입니다')
        } else if (!isEmail(email)) {
            return res.status(422).send('유효하지 않은 이메일 형식입니다')
        }
        const user = await User.findOne({ email })
        if (user) {
            return res.status(422).send(`${email}이 이미 사용중입니다`)
        }
        const hash = await bcrypt.hash(password, 10)
        const newUser = await new User({
            name,
            email,
            password: hash
        }).save() //save하면 몽고 db에 들어간다 save method가 promise
        console.log(newUser)
        res.json(newUser) //json형식으로 바꿔서 문자열로 보낸다 client쪽으로
    } catch (error) { //다른 과정에서 에러가 나면 실행 
        console.log(error)
        res.status(500).send('회원가입 에러')
    }
}

const userById = async (req, res, next, id) => {
    try {
        const user = await User.findById(id)
        if (!user) {
            res.status(404).send('사용자를 찾을 수 없습니다')
        }
        req.profile = user
        next()
    } catch (error) {
        console.log(error)
        res.status(500).send('사용자 아이디 검색 실패')
    }
}

const getBookmark = async (req, res) => {
    const { bookmark, userId } = req.body
    console.log(bookmark, userId)
    // const bookpage = req.body.bookmark
    console.log('page:', bookmark)
    // const user = req.user.userId
    console.log('userId:', userId)
    const updatedUser = await User.findOne({ _id: userId })
    if (updatedUser) {
        updatedUser.bookmark = bookmark
        updatedUser.save()
    }
    // const updatedUser = await new User({ bookmark }).save()
    // res.json(updatedUser)
    console.log(updatedUser)
    res.send(updatedUser)
}

const setBookmark = async (req, res) => {
    // const place = await Place.findOne(address)
    // const bookmarkUser = await User.findOne({ place }.populate(bookmark))
    // if (bookmarkUser) {

    //     bookmarkUser.save()
    // }
    console.log(req.query.ID, req.query.place, "여기에요 여기!!!!")
    await User.updateOne({ _id: req.query.ID }, { $push: { bookmark: req.query.place } })
    res.send("추가완료")
}

const deleteBookmark = async (req, res) => {
    console.log(req.query.ID, req.query.place)
    await User.updateOne({ _id: req.query.ID }, { $pull: { bookmark: req.query.place } })
    res.send("삭제완료")
}

export default { signup, userById, getBookmark, setBookmark, deleteBookmark }