import axios from 'axios';
import React, { useEffect, useState } from 'react';
import { Container, Row, Button, Col, ListGroup} from 'react-bootstrap';
import queryString from 'query-string'

function Place(props) {
  console.log(props)
  const [db, setDb] = useState(false)
  const [index, setIndex] = useState(0)
  const [reviews, setReviews] = useState([])
  const place = queryString.parse(props.location.search).place

  const getReview = (index) => {
    console.log(index, "dlseprtm")
    axios({ url: `/api/review?keyword=${place}&index=${index}`, method: 'post', data: { db: db } })
      .then(res => {
        console.log("place res.data", res.data)
        setReviews([...reviews, ...res.data.review])
        setDb(res.data.db)
        setIndex(res.data.index)
      })
      .then(() => {
        console.log(index, "인텍스", db)
      })
      .catch(err => {
        console.log(err)
      })
  }

  useEffect(() => {
    getReview();
    window.addEventListener("scroll", infiniteScroll);
    return () => { window.removeEventListener("scroll", infiniteScroll); }
  }, []);

  // useEffect(() => {
  //   getReview();

  // }, [index])

  const infiniteScroll = () => {
    const { documentElement, body } = document;
    const scrollHeight = Math.max(documentElement.scrollHeight, body.scrollHeight);
    const scrollTop = Math.max(documentElement.scrollTop, body.scrollTop);
    const clientHeight = documentElement.clientHeight;
    if (scrollTop + clientHeight >= scrollHeight) {
      // setIndex(index + 1)
      getReview(index + 1);
      console.log("더불러", index + 1)
    }
    console.log(scrollHeight, scrollTop, clientHeight)
  }

  return (
    <Container {...props}>
      <Row>
      {place}
      {Array.isArray(reviews) ? reviews.map((review, index) => {
        return (
          <ListGroup>
          <ListGroup.Item className="mt-4">
            <a href={review.link}>{review.title}</a>
            <div>{review.summary}</div>
            <div>{review.content}</div>
          </ListGroup.Item>
          </ListGroup>
        )
      })
      : "리뷰가 없습니다."}
      </Row>
    </Container>
  );
}

export default Place;
