import React, { useState, useEffect } from 'react'
import { Alert, Col, Card, Container, Form, Row, Button, Nav, Navbar, ListGroup, Image, Table } from "react-bootstrap"
import axios from "axios"
import catchErrors from './utils/catchErrors.js'
import { isAuthenticated } from './utils/auth'
import { Redirect } from 'react-router-dom'

const INIT_PAGE = {
    bookmark: ['제주도'],
    bookmark: ['한라산'],

}

const user = isAuthenticated()

function Bookmark() {
    const [page, setPage] = useState(INIT_PAGE)
    const [error, setError] = useState('')

    const user = isAuthenticated()

    async function getBookmark(user) {
        try {
            setError('')
            const response = await axios.post(`/api/users/bookmark/${user}`)
            setPage(response.data)
        } catch (error) {
            catchErrors(error, setError)
        }   
    }

    useEffect(() => {
        Bookmark(user)
    }, [user])



    return (
        <Container>
            <Navbar bg="primary" variant="dark">
                <Navbar.Brand href="/">북마크</Navbar.Brand>
                <Nav className="mr-auto">
                    <Nav.Link href="/">Home</Nav.Link>
                </Nav>
            </Navbar>
                <Form>
                    <ListGroup>
                        <ListGroup.Item value={page.bookmark}></ListGroup.Item>
                        <ListGroup.Item></ListGroup.Item>
                    </ListGroup>
                </Form>
        </Container>
    )
}

export default Bookmark