import React, { useEffect, useState } from 'react';
import { Link, Redirect } from 'react-router-dom';
import ohuh from '../ohuh.PNG';
import { Container, Row, Form, Image, InputGroup, Button, Col, FormControl } from 'react-bootstrap';

function App() {
  const [state, setState] = useState(false);
  const [search, setSearch] = useState("");

  if (state !== false) {
    return <Redirect to={{
      pathname: `/search/${search}`,
      state: { id: search },
    }} />;
  }

  const handleChange = (e) => {
    setSearch(e.target.value);
  }

  const handleSubmit = () => {
    setState(true);
  }



  return (
    <Container className="vh-100">
      <Row className="d-flex justify-content-md-center">
        <Col md={6} className="mt-5">
          <Image src={ohuh} fluid />
        </Col>
        <Col lg={{ span: 10, offset: 1 }} > 
          <InputGroup size="lg" lg={6} xs={4} fluid>
            <FormControl
              className="d-flex justify-content-lg-center"
              placeholder="검색어를 입력하세요."
              aria-label="Large"
              aria-describedby="inputGroup-sizing-sm"
              onChange={handleChange}
            />
            <InputGroup.Append>
              <Button variant="outline-secondary" onClick={handleSubmit}>검색</Button>
            </InputGroup.Append>
          </InputGroup>
        </Col>
      </Row>
    </Container>

  );
}

export default App;